<!DOCTYPE html>
    <html lang="en">
    <head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- CSS -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css',
        'resources/js/app.js',
        'resources/js/main.js',
	'resources/js/ubicaciones.js',
	'node_modules/boxicons/css/boxicons.min.css',
	'resources/css/styles.css']); ?>

    <!-- Título de la página -->
    <title>El Salvador :: Ministerio de Salud :: Encuesta Nacional de Primera Infancia, Niñez y Adolescencia 2025</title>

    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('assets/apple-touch-icon.png')); ?>">
    <link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(asset('assets/favicon-32x32.png')); ?>">
    <!-- Bootstrap 4 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- DataTables CSS para Bootstrap 4 -->
    <link href="https://cdn.datatables.net/1.13.5/css/jquery.dataTables.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/1.13.5/css/dataTables.bootstrap4.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/responsive/2.4.1/css/responsive.dataTables.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/responsive/2.4.1/css/responsive.bootstrap4.min.css" rel="stylesheet">

    <!-- Select2 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet">

    <!-- Date Range Picker CSS -->
    <link href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" rel="stylesheet">
    
    <?php echo $__env->yieldPushContent('styles'); ?> <!-- Pueden agregarse estilos adicionales en las vistas -->
    </head>

    <body>
        <!--========== HEADER ==========-->
        <div class="nav" id="navbar">
            <nav class="nav__container">
		<div>
                    <a href="#" class="nav__link nav__logo">
                        <i class='bx bxs-disc nav__icon' ></i>
                        <span class="nav__logo-name">MINSAL</span>
                    </a>
                    <div class="nav__list">
			<?php if(auth()->guard()->check()): ?>
                        <?php if(auth()->user()->hasRole('Coordinador/a')): ?>

                        <div class="nav__items">

                            <h3 class="nav__subtitle">CARTOGRAFÍA</h3>

			     <a href="<?php echo e(route('home')); ?>" class="nav__link">
                                <i class='bx bx-home nav__icon' ></i>
                                <span class="nav__name">Segmentos</span>
                             </a>

                             <div class="nav__dropdown">
                                <a href="#" class="nav__link">
                                    <i class='bx bx-user nav__icon' ></i>
                                    <span class="nav__name">Coordinación local</span>
                                    <i class='bx bx-chevron-down nav__icon nav__dropdown-icon'></i>
                                </a>

                                <div class="nav__dropdown-collapse">
                                    <div class="nav__dropdown-content">
                                        <a href="<?php echo e(route('survey.show', ['id' => 1])); ?>" class="nav__dropdown-item">FORMULARIO I</a>
                                        <a href="<?php echo e(route('survey.show', ['id' => 2])); ?>" class="nav__dropdown-item">FORMULARIO II</a>
					<a href="<?php echo e(route('survey.show', ['id' => 2])); ?>" class="nav__dropdown-item">INFORME DE ACTIVIDADES</a>
                                    </div>
                                </div>
                            </div>
			<?php endif; ?>
                        <?php if(auth()->user()->hasRole('Encuestador/a')): ?>

			<div class="nav__items">
                            <div class="nav__dropdown">
                                <a href="#" class="nav__link">
                                    <i class='bx bx-user nav__icon' ></i>
                                    <span class="nav__name">HOGARES</span>
                                    <i class='bx bx-chevron-down nav__icon nav__dropdown-icon'></i>
                                </a>

                                <div class="nav__dropdown-collapse">
                                    <div class="nav__dropdown-content">
                                        <a href="<?php echo e(route('households.index')); ?>" class="nav__dropdown-item">HOGARES</a>
                                        <a href="<?php echo e(route('household_members.index')); ?>" class="nav__dropdown-item">MIEMBROS</a>
                                        <a href="<?php echo e(route('household_teams.index')); ?>" class="nav__dropdown-item">TABULADOR</a>

                                    </div>
                                </div>
                            </div>
                        </div>
			 <?php endif; ?>
            		<?php endif; ?>
			<?php if(auth()->guard()->check()): ?>
                	<?php if(auth()->user()->hasRole('Administrador')): ?>
                        <div class="nav__items">
                            <h3 class="nav__subtitle">ADMIN</h3>
			 <div class="nav__dropdown">
                                <a href="#" class="nav__link">
                                    <i class='bx bxs-folder-open nav__icon' ></i>
                                    <span class="nav__name">REGISTRO/BÚSQUEDA</span>
                                    <i class='bx bx-chevron-down nav__icon nav__dropdown-icon'></i>
                                </a>

                                <div class="nav__dropdown-collapse">
                                    <div class="nav__dropdown-content">
                                        <a href="<?php echo e(route('home')); ?>" class="nav__dropdown-item">VER SEGMENTOS</a>
                                        <a href="<?php echo e(route('household_members.index')); ?>" class="nav__dropdown-item">COORD. LOCAL</a>
					<a href="<?php echo e(route('household_teams.index')); ?>" class="nav__dropdown-item">ASIGNACIÓN HOGARES</a>
					<a href="<?php echo e(route('household_teams.index')); ?>" class="nav__dropdown-item">LEVANTAMIENTO</a>
					<a href="<?php echo e(route('household_teams.index')); ?>" class="nav__dropdown-item">MEDICIONES</a>
					<a href="<?php echo e(route('household_teams.index')); ?>" class="nav__dropdown-item">LABORATORIO</a>
                                    </div>
                                </div>
                         </div>
 			 <div class="nav__dropdown">
                                <a href="#" class="nav__link">
                                    <i class='bx bx-stats nav__icon' ></i>
                                    <span class="nav__name">REPORTES</span>
                                    <i class='bx bx-chevron-down nav__icon nav__dropdown-icon'></i>
                                </a>

                                <div class="nav__dropdown-collapse">
                                    <div class="nav__dropdown-content">
                                        <a href="<?php echo e(route('home')); ?>" class="nav__dropdown-item">INDICADORES</a>
                                        <a href="<?php echo e(route('household_members.index')); ?>" class="nav__dropdown-item">EFECTIVIDAD POR HOGAR</a>
                                        <a href="<?php echo e(route('household_teams.index')); ?>" class="nav__dropdown-item">EFECTIVIDAD POR EDAD</a>
                                        <a href="<?php echo e(route('household_teams.index')); ?>" class="nav__dropdown-item">RENDIMIENTO POR EQUIPO</a>
                                        <a href="<?php echo e(route('household_teams.index')); ?>" class="nav__dropdown-item">RENDIMIENTO POR RECURSO</a>
                                    </div>
                                </div>
                         </div>
			<div class="nav__dropdown">
                                <a href="#" class="nav__link">
                                    <i class='bx bx-list-ol nav__icon' ></i>
                                    <span class="nav__name">LISTADOS</span>
                                    <i class='bx bx-chevron-down nav__icon nav__dropdown-icon'></i>
                                </a>

                                <div class="nav__dropdown-collapse">
                                    <div class="nav__dropdown-content">
                                        <a href="<?php echo e(route('home')); ?>" class="nav__dropdown-item">PERSONAS POR HOGAR</a>
                                        <a href="<?php echo e(route('household_members.index')); ?>" class="nav__dropdown-item">PERSONAS ENTREVISTADAS</a>
                                        <a href="<?php echo e(route('household_teams.index')); ?>" class="nav__dropdown-item">PERSONAS POR MEDICIONES</a>
                                        <a href="<?php echo e(route('household_teams.index')); ?>" class="nav__dropdown-item">PERSONAS POR LABORATORIO</a>
                                        <a href="<?php echo e(route('household_teams.index')); ?>" class="nav__dropdown-item">BASE DE DATOS</a>
                                    </div>
                                </div>
                         </div>
			<div class="nav__dropdown">
                                <a href="#" class="nav__link">
                                    <i class='bx bxs-book nav__icon' ></i>
                                    <span class="nav__name">MATERIAL APOYO</span>
                                    <i class='bx bx-chevron-down nav__icon nav__dropdown-icon'></i>
                                </a>

                                <div class="nav__dropdown-collapse">
                                    <div class="nav__dropdown-content">
                                        <a href="<?php echo e(route('home')); ?>" class="nav__dropdown-item">FORMULARIOS</a>
                                        <a href="<?php echo e(route('household_members.index')); ?>" class="nav__dropdown-item">TABULADORES DIARIOS</a>
                                        <a href="<?php echo e(route('household_teams.index')); ?>" class="nav__dropdown-item">MANUAL DE USUARIO</a>
                                    </div>
                                </div>
                         </div>
			<div class="nav__dropdown">
                                <a href="#" class="nav__link">
                                    <i class='bx bx-code nav__icon' ></i>
                                    <span class="nav__name">ADMINSTRACIÓN</span>
                                    <i class='bx bx-chevron-down nav__icon nav__dropdown-icon'></i>
                                </a>

                                <div class="nav__dropdown-collapse">
                                    <div class="nav__dropdown-content">
                                        <a href="<?php echo e(route('roles.index')); ?>" class="nav__dropdown-item">ROLES</a>
                                        <a href="<?php echo e(route('users.index')); ?>" class="nav__dropdown-item">USUARIOS</a>
					<a href="<?php echo e(route('teams.index')); ?>" class="nav__dropdown-item">EQUIPOS</a>
					<a href="<?php echo e(route('households.index')); ?>" class="nav__dropdown-item">HOGARES</a>
					<a href="<?php echo e(route('household_members.index')); ?>" class="nav__dropdown-item">MIEMBROS</a>
                                        <a href="<?php echo e(route('home')); ?>" class="nav__dropdown-item">BITACORA</a>
                                        <a href="<?php echo e(route('home')); ?>" class="nav__dropdown-item">DICCIONARIO</a>
                                        <a href="<?php echo e(route('home')); ?>" class="nav__dropdown-item">SINTAXIS Y TABULADOS</a>
                                    </div>
                                </div>
                         </div>

	

			<?php endif; ?>
            <?php endif; ?>
                </div>
		</div>
		</div>

                <a class="nav__link nav__logout"  href="<?php echo e(route('logout')); ?>"
                                       onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">
                    <i class='bx bx-log-out nav__icon' ></i>
                    <span class="nav__name">Cerrar Sesión</span>
			<form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                              <?php echo csrf_field(); ?>
                        </form>
                </a>
            </nav>
        </div>

        <!--========== CONTENTS ==========-->
       	<main>
	<div class="topbar flex">
    	    <div class="right-side flex">
		    <div class="theme flex">
		        <div class="dark flex">
		            <i class='bx bx-moon'></i>
		        </div>
		        <div class="light active flex">
		            <i class='bx bx-sun'></i>
		        </div>
		    </div>

		    <div class="notification icon">
		        <i class='bx bx-bell'></i>
		    </div>

		    <div class="user flex flex-sb">
  		   	<?php if(Auth::user()->sexo === 1): ?>
		            <img src="<?php echo e(asset('assets/man.png')); ?>" alt="Foto de perfil" />
			<?php else: ?>
			    <img src="<?php echo e(asset('assets/female.png')); ?>" alt="Foto de perfil">
			<?php endif; ?>
		    <div>
		        <p><?php echo e(Auth::user()->name); ?></p>
        		<p style="font-size: 12px; color: gray;"><?php echo e(Auth::user()->role->name); ?></p> <!-- Ejemplo de uso del campo 'role' -->
		    </div>
		        <i class='bx bx-chevron-down' id="user-dropdown-toggle"></i>
			<!-- Menú desplegable -->
    			<div class="dropdown-menu2" id="user-dropdown-menu" style="display: none;">
        		    <a href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault(); document.getElementById('logout-form').submit();"> <i class='bx bx-log-out nav__icon' ></i>
Cerrar sesión</a>

        		    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
        			    <?php echo csrf_field(); ?>
			    </form>
			</div>
		    </div>
		</div>
	</div>
        <!-- ======End Topbar======= -->
        	<?php echo $__env->yieldContent('content'); ?>
    	</main>
	<footer>
        	<!-- Incluye tu propio HTML para el footer -->
    	</footer>
        <!-- JS -->
	<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

       	<!-- Popper.js para Bootstrap 4 -->
    	<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.1/umd/popper.min.js"></script>

	<!-- JavaScript de Bootstrap -->
	<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/js/bootstrap.bundle.min.js"></script>

	<!-- DataTables y Popper para Bootstrap 4 -->
	<script src="https://cdn.datatables.net/1.13.5/js/jquery.dataTables.min.js"></script>
	<script src="https://cdn.datatables.net/1.13.5/js/dataTables.bootstrap4.min.js"></script>
	<script src="https://cdn.datatables.net/responsive/2.4.1/js/dataTables.responsive.min.js"></script>
	<script src="https://cdn.datatables.net/responsive/2.4.1/js/responsive.bootstrap4.min.js"></script>

	<!-- Select2 JS -->
	<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

	<!-- Date Range Picker JS -->
	<script src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.js"></script>
    	<?php echo $__env->yieldPushContent('scripts'); ?>
	<!-- Idle Timeout Script -->
    	<script>
    let idleTime = 0;

    const timerIncrement = () => {
        idleTime++;
        if (idleTime > 60) { // 0.16 minutos = 10 segundos para prueba
            localStorage.setItem('isLocked', 'true');
            window.location.href = '<?php echo e(route('screen.lock')); ?>';
        }
    };

    document.onmousemove = document.onkeypress = () => {
        idleTime = 0;
    };

    setInterval(timerIncrement, 60000); // 1 minuto

    document.addEventListener('DOMContentLoaded', function() {
        if (localStorage.getItem('isLocked') === 'true') {
            window.location.href = '<?php echo e(route('screen.lock')); ?>';
        }
    });

    window.onpopstate = function() {
        if (localStorage.getItem('isLocked') === 'true') {
            window.location.href = '<?php echo e(route('screen.lock')); ?>';
        }
    };
    const dark = document.querySelector(".dark");
const light = document.querySelector(".light");

dark.addEventListener("click", function () {
  document.querySelector("body").classList.add("darkMode");
  light.classList.remove("active");
  dark.classList.add("active");
});

light.addEventListener("click", function () {
  document.querySelector("body").classList.remove("darkMode");
  dark.classList.remove("active");
  light.classList.add("active");
});
document.getElementById('user-dropdown-toggle').addEventListener('click', function() {
    var dropdownMenu = document.getElementById('user-dropdown-menu');
    if (dropdownMenu.style.display === "none") {
        dropdownMenu.style.display = "block";
    } else {
        dropdownMenu.style.display = "none";
    }
});

// Cerrar el menú si se hace clic fuera de él
window.addEventListener('click', function(event) {
    if (!event.target.matches('#user-dropdown-toggle')) {
        var dropdownMenu = document.getElementById('user-dropdown-menu');
        if (dropdownMenu.style.display === "block") {
            dropdownMenu.style.display = "none";
        }
    }
});

</script>

    </body>
</html>
<?php /**PATH /var/www/html/EncuestaProject/resources/views/layouts/main.blade.php ENDPATH**/ ?>