import { defineConfig } from 'vite';
import laravel from 'laravel-vite-plugin';
import vue from '@vitejs/plugin-vue';

export default defineConfig({
   server: {
        host: '0.0.0.0',
        port: 5173,
        hmr: {
            host: '146.190.168.167',
        },
    },
     plugins: [
        laravel({
            input: [
		'resources/sass/app.scss',
                'resources/css/app.css',
                'resources/css/login.css',
                'resources/css/util.css',
                'resources/css/stepper.css',
                'resources/css/form1.css',
                'node_modules/boxicons/css/boxicons.min.css',
		'resources/css/styles.css',
                // JavaScript
                'resources/js/app.js',
                'resources/js/form1.js',
                'resources/js/main.js',
                'resources/js/ubicaciones.js',
                'resources/js/populateSelect.js',
                'resources/js/populateSelect2.js',
            ],
            refresh: true,
        }),
        vue({
            template: {
                transformAssetUrls: {
                    base: null,
                    includeAbsolute: false,
                },
            },
        }),
    ],
    resolve: {
        alias: {
            vue: 'vue/dist/vue.esm-bundler.js',
            '$': 'jquery',
        },
    },
});
