<?php

namespace App\Http\Controllers;

use App\Models\Answer;
use Illuminate\Http\Request;

class AnswerController extends Controller
{
    // Mostrar todas las respuestas para una pregunta específica
    public function index($questionId)
    {
        $answers = Answer::where('question_id', $questionId)->get();
        return response()->json($answers);
    }

    // Guardar respuestas
    public function store(Request $request)
    {
        $request->validate([
            'question_id' => 'required|exists:questions,id',
            'responses' => 'required|array',
            'responses.*' => 'string',
        ]);

        $responses = $request->input('responses');
        foreach ($responses as $response) {
            Answer::create([
                'question_id' => $request->input('question_id'),
                'text' => $response,
            ]);
        }

        return response()->json(['message' => 'Respuestas guardadas con éxito'], 201);
    }
}

