<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Segment;
use App\Models\Team;
use App\Models\Region;


class APIController extends Controller
{
    public function getSegments(Request $request)
    {
        try {
            $segments = Segment::all();
            return response()->json($segments, 200);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Error fetching segments'], 500);
        }
    }

    public function getTeams(Request $request)
    {
        try {
            $teams = Team::all();
            return response()->json($teams, 200);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Error fetching teams'], 500);
        }
    }
    public function getRegions(Request $request) {
    	$correlativoSegmento = $request->input('filter');
    	// Filtrar las regiones basadas en correlativoSegmento
    	$regions = Region::where('segment_id', $correlativoSegmento)->get(['id', 'name as text']);
    	return response()->json($regions);
    }

}
