<?php

namespace App\Http\Controllers;

use App\Models\FormSection;
use App\Models\Form; // Asegúrate de que el modelo Form esté importado
use Illuminate\Http\Request;

class FormSectionController extends Controller
{
    public function index()
    {
        $formSections = FormSection::all();
        return view('survey.form_sections.index', compact('formSections'));
    }

    public function create()
    {
        $forms = Form::all(); // Obtener todos los formularios
        return view('survey.form_sections.create', compact('forms'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'form_id' => 'required|exists:forms,id',
            'section_name' => 'required|string|max:255',
            'section_order' => 'required|integer',
            'description' => 'nullable|string',
        ]);

        FormSection::create($request->all());

        return redirect()->route('form_sections.index')->with('success', 'Sección creada con éxito.');
    }

    public function edit($id)
    {
        $formSection = FormSection::findOrFail($id);
        $forms = Form::all(); // Obtener todos los formularios
        return view('survey.form_sections.edit', compact('formSection', 'forms'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'form_id' => 'required|exists:forms,id',
            'section_name' => 'required|string|max:255',
            'section_order' => 'required|integer',
            'description' => 'nullable|string',
        ]);

        $formSection = FormSection::findOrFail($id);
        $formSection->update($request->all());

        return redirect()->route('form_sections.index')->with('success', 'Sección actualizada con éxito.');
    }

    public function destroy($id)
    {
        $formSection = FormSection::findOrFail($id);
        $formSection->delete();

        return redirect()->route('form_sections.index')->with('success', 'Sección eliminada con éxito.');
    }
}
