<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\SegmentUser;
use App\Models\Segment;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
	$user = Auth::user();
	// Obtener el ID del usuario autenticado
        $userId = Auth::id();

        // Obtener los segmentos asignados al coordinador
	
    $segments = SegmentUser::where('user_id', $userId)
                    ->with([ 'segment.departamento', 'segment.municipio', 'segment.distrito', 'segment.canton'])
                    ->get();

    // Puedes acceder a los nombres de cada uno de los niveles
    foreach ($segments as $segmentUser) {
        $departamentoName = $segmentUser->segment->departamento->nombre ?? 'N/A';
        $municipioName = $segmentUser->segment->municipio->nombre ?? 'N/A';
        $distritoName = $segmentUser->segment->distrito->nombre ?? 'N/A';
        $areaName = $segmentUser->segment->canton->nombre ?? 'N/A';
        
        // Puedes usar estos valores en la vista o procesarlos según sea necesario
    }

    // Lógica para la vista según el rol del usuario
    if ($user->role->name == 'Encuestador/a') {
        return view('dashboard.encuestador');
    } elseif ($user->role->name == 'Supervisor/a') {
        return view('dashboard.supervisor');
    } elseif ($user->role->name == 'Administrador') {
	 $segments = Segment::where('active', 1)
	    ->with([ 'departamento', 'municipio', 'distrito', 'canton'])
            ->get();


	    // Puedes acceder a los nombres de cada uno de los niveles
	    foreach ($segments as $segment) {
	        $departamentoName = $segment->departamento->nombre ?? 'N/A';
	        $municipioName = $segment->municipio->nombre ?? 'N/A';
	        $distritoName = $segment->distrito->nombre ?? 'N/A';
	        $areaName = $segment->canton->nombre ?? 'N/A';

	        // Puedes usar estos valores en la vista o procesarlos según sea necesario
	    }

        return view('dashboard.admin', compact('segments'));
    } elseif ($user->role->name == 'Coordinador/a') {
        // Pasamos los segmentos y las variables de nombres a la vista de coordinador
        return view('dashboard.coordinador', compact('segments'));
    } else {
        return view('home');
    }
}

}
