<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use phayes\geoPHP\geoPHP;

class KMLController extends Controller
{
    public function processKML(Request $request)
    {
        try {
            $request->validate([
                'kml_file' => 'required|file|mimes:kml,xml',
            ]);

            $path = $request->file('kml_file')->store('kml_files');

            $kmlContent = Storage::get($path);

            $geoPhp = geoPHP::load($kmlContent, 'kml');
            $geoJson = $geoPhp->out('json');

            return response()->json(['geometries' => json_decode($geoJson)]);
        } catch (\Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }
    public function showMap()
    {
    	return view('kml.map');
    }
}

