<?php

namespace App\Http\Controllers;

use App\Models\SectionQuestion;
use App\Models\FormSection;
use App\Models\Question;
use Illuminate\Http\Request;

class SectionQuestionController extends Controller
{
    public function create()
    {
        $sections = FormSection::all();
        $questions = Question::all();
        return view('survey.section_questions.create', compact('sections', 'questions'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'section_id' => 'required|integer|exists:form_sections,id',
            'question_id' => 'required|integer|exists:questions,id',
            'question_order' => 'required|integer',
	    'question_enum' => 'nullable|string|max:50',

        ]);

        SectionQuestion::create([
            'section_id' => $request->section_id,
            'question_id' => $request->question_id,
            'question_order' => $request->question_order,
	    'question_enum' => $request->question_enum,
        ]);

        return redirect()->route('section_questions.index')->with('success', 'Pregunta agregada a la sección con éxito.');
    }

    public function index()
    {
        $sectionQuestions = SectionQuestion::with('section', 'question')->get();
        return view('survey.section_questions.index', compact('sectionQuestions'));
    }

    public function edit($id)
    {
        $sectionQuestion = SectionQuestion::findOrFail($id);
        $sections = FormSection::all();
        $questions = Question::all();
        return view('survey.section_questions.edit', compact('sectionQuestion', 'sections', 'questions'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'section_id' => 'required|integer|exists:form_sections,id',
            'question_id' => 'required|integer|exists:questions,id',
            'question_order' => 'required|integer',
        ]);

        $sectionQuestion = SectionQuestion::findOrFail($id);
        $sectionQuestion->update([
            'section_id' => $request->section_id,
            'question_id' => $request->question_id,
            'question_order' => $request->question_order,
        ]);

        return redirect()->route('section_questions.index')->with('success', 'Pregunta actualizada con éxito.');
    }

    public function destroy($id)
    {
        SectionQuestion::findOrFail($id)->delete();
        return redirect()->route('section_questions.index')->with('success', 'Pregunta eliminada con éxito.');
    }
}
