<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\SegmentUser;
use App\Models\User;
use App\Models\Segment;

class SegmentUserController extends Controller
{
      // Método para mostrar el listado en el index
    public function index()
    {
        // Obtener todos los registros de la tabla segment_user con los datos relacionados
        $segmentUsers = SegmentUser::with(['user', 'segment'])->get();

        return view('segment-user.index', compact('segmentUsers'));
    }

    public function create()
    {
        // Obtener los usuarios con rol de coordinador (asumimos que el rol de coordinador tiene un ID específico, por ejemplo, 2).
        $coordinators = User::where('role_id', 5)->get();

        // Obtener los segmentos que están activos (active = 1).
        $segments = Segment::where('active', 1)->get();

        return view('segment-user.create', compact('coordinators', 'segments'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'correlativo_segmento' => 'required|string|max:255',
            'user_id' => 'required|exists:users,id',
	    'coordinacion' => 'required',
        ]);

        $segmentUser = new SegmentUser();
        $segmentUser->correlativo_segmento = $request->input('correlativo_segmento');
        $segmentUser->user_id = $request->input('user_id');
	$segmentUser->coordinacion = $request->input('coordinacion');
        $segmentUser->save();
	$segmentUsers = SegmentUser::with(['user', 'segment'])->get();

        return view('segment-user.index', compact('segmentUsers'))->with('success', 'Segmento asignado correctamente.');
    }
    
    public function edit($id)
    {
    	$segmentUser = SegmentUser::findOrFail($id);
    	$segments = Segment::where('active', 1)->get();
    	$coordinators = User::where('role_id', 5)->get(); // Suponiendo que '2' es el rol de coordinador

    	return view('segment-user.edit', compact('segmentUser', 'segments', 'coordinators'));
    }
    public function update(Request $request, $id)
    {
        // Validar los datos de entrada
        $request->validate([
            'correlativo_segmento' => 'required|exists:segments,correlativo_segmento',
            'user_id' => 'required|exists:users,id',
        ]);

        // Encontrar el registro a actualizar
        $segmentUser = SegmentUser::findOrFail($id);

        // Actualizar los campos
        $segmentUser->correlativo_segmento = $request->correlativo_segmento;
        $segmentUser->user_id = $request->user_id;

        // Guardar los cambios en la base de datos
        $segmentUser->save();

        // Redirigir a la vista de índice con un mensaje de éxito
        return redirect()->route('segment_user.index')->with('success', 'Segmento actualizado exitosamente.');
    }
    public function destroy($id)
    {
        // Encontrar el registro a eliminar
        $segmentUser = SegmentUser::findOrFail($id);

        // Eliminar el registro
        $segmentUser->delete();

        // Redirigir a la vista de índice con un mensaje de éxito
        return redirect()->route('segment_user.index')->with('success', 'Segmento eliminado exitosamente.');
    }
}
