<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Role;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

class UserController extends Controller
{
    public function index()
    {
	$users = User::with(['role'])->get();
        return view('users.index', compact('users'));
    }
    public function create()
    {
	$roles = Role::all();
        return view('users.create', compact('roles'));
    }

    public function store(Request $request)
    {
         $validator = Validator::make($request->all(), [
            'name' => 'required|string|max:255',
            'email' => 'required|string|email|max:255|unique:users',
            'username' => 'required|string|max:255|unique:users',
            'password' => 'required|string|min:8|confirmed',
            'role_id' => 'required|exists:roles,id',
	    'role_id' => 'required',
        ]);
	if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }
        User::create([
            'name' => $request->name,
            'email' => $request->email,
	    'username' => $request->username,
            'password' => Hash::make($request->password),
	    'role_id' => $request->role_id,
	    'sexo' => $request->sexo,
        ]);

        return redirect()->route('home')->with('success', 'Usuario creado exitosamente.');
    }
	 public function edit($id)
    {
        $user = User::findOrFail($id);
	$roles = Role::all();
        return view('users.edit', compact('user', 'roles'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => 'required',
            'email' => 'required|email|unique:users,email,' . $id,
            'password' => 'nullable|min:8',
   	    'role_id' => 'required|exists:roles,id',
	    'sexo' => 'required',

        ]);

        $user = User::findOrFail($id);
        $user->name = $request->name;
        $user->email = $request->email;
        if ($request->password) {
            $user->password = bcrypt($request->password);
        }
	$user->role_id = $request->role_id;
	$user->sexo = $request->sexo;

        $user->save();

        return redirect()->route('users.index')->with('success', 'User updated successfully.');
    }
    public function destroy($id)
    {
        $user = User::findOrFail($id);
        $user->delete();

        return redirect()->route('users.index')->with('success', 'Usuario eliminado exitosamente');
    }
}

