<?php

// app/Imports/HouseholdsImport.php

namespace App\Imports;

use App\Models\Household;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Illuminate\Support\Carbon;

class HouseholdsImport implements ToModel, WithHeadingRow
{
    public function model(array $row)
    {
        return new Household([
            'correlativo_segmento' => $row['correlativo_segmento'],
            'region_de_salud' => $row['region_de_salud'],
            'departamento' => $row['departamento'],
            'municipio' => $row['municipio'],
            'distrito' => $row['distrito'],
            'area' => $row['area'],
	    'direccion'=> $row['direccion'],
            'orden_vivienda' => $row['orden_vivienda'],
            'numero_vivienda' => isset($row['numero_vivienda']) ? $row['numero_vivienda'] : null,
            'replacement' => $row['replacement'],
	    'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
        ]);
    }
}

