<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Distrito extends Model
{
    use HasFactory;

    protected $table = 'distrito'; // Nombre de la tabla en la base de datos

    protected $fillable = [
        'codigo',
        'nombre',
        'muni' // Nombre de la columna para el municipio
    ];

    public $timestamps = false; // Si no usas timestamps

    public function muni()
    {
        return $this->belongsTo(Muni::class, 'muni', 'codigo');
    }
    public function canton()
    {
        return $this->hasMany(Canton::class, 'district', 'codigo');
    }
    public function establishments()
    {
        return $this->hasMany(Establishment::class, 'distrito', 'codigo');
    }
}
