<?php

// app/Models/HouseholdTeam.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class HouseholdTeam extends Model
{
    use HasFactory;

    protected $table = 'segment_team';

    protected $fillable = [
        'correlativo_segmento',
        'team_id',
	'user_id', 
	'team_id_old',
	'reassignment_count'
    ];

    public function segment()
    {
        return $this->belongsTo(Segment::class, 'correlativo_segmento', 'correlativo_segmento');
    }

    public function team()
    {
        return $this->belongsTo(Team::class);
    }
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
