<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Muni extends Model
{
    use HasFactory;

    protected $table = 'muni'; // Nombre de la tabla en la base de datos

    protected $fillable = [
        'codigo',
        'nombre',
        'dpto' // Nombre de la columna para el departamento
    ];

     public $timestamps = false; // Si no usas timestamps
     public function dpto()
    {
        return $this->belongsTo(Dpto::class, 'dpto', 'codigo');
    }
    public function distrito()
    {
        return $this->hasMany(Distrito::class, 'muni', 'codigo');
    }
    public function establishments()
    {
        return $this->hasMany(Establishment::class, 'muni', 'codigo');
    }
}
