<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OptionCondition extends Model
{
    use HasFactory;

    protected $table = 'option_conditions';

    protected $fillable = [
    'question_id',
    'dependent_question_id',
    'option_type',
    'option_value',
    'condition_logic', // Campo agregado para la lógica de las condiciones
    'created_at',
    'updated_at'
    ];


    public function question()
    {
        return $this->belongsTo(Question::class, 'question_id');
    }

    public function dependentQuestion()
    {
        return $this->belongsTo(Question::class, 'dependent_question_id');
    }
}
