<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Region extends Model
{
    protected $table = 'region'; // Nombre de la tabla en la base de datos

    protected $fillable = [
        'nombre',
        'codigo',
    ];

     public $timestamps = false; // Si no usas timestamps
    
    public function segments()
    {
        // Un 'region' puede tener muchos segmentos
        return $this->hasMany(Segment::class, 'region', 'codigo');
    }
}
