<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Section extends Model
{
    use HasFactory;

    protected $table = 'form_sections';

    protected $fillable = [
        'form_id',
        'section_name',
        'section_order',
        'description',
        'created_at',
        'updated_at',
    ];

     public function forms()
    {
        return $this->belongsToMany(Form::class, 'form_sections', 'section_id', 'form_id')
                    ->withPivot('form_id', 'section_id')
                    ->withTimestamps();
    }

    /**
     * Relación con la tabla Question.
     * Una sección puede tener muchas preguntas.
     */
    public function questions()
    {
        return $this->belongsToMany(Question::class, 'sections_questions', 'section_id', 'question_id')
                    ->withPivot('section_id', 'question_id')
                    ->withTimestamps();
    }

    /**
     * Obtener el formulario al que pertenece la sección.
     */
    public function form()
    {
        return $this->belongsTo(Form::class, 'form_id');
    }
}
