<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SegmentMember extends Model
{
    protected $table = 'segment_members';

    // Si la tabla no sigue las convenciones de Laravel para timestamps, añade esta línea:
    public $timestamps = false;

    // Los campos que se pueden llenar en esta tabla
    protected $fillable = [
        'orden_vivienda',
        'num_casa',
        'grupo_edad',
        'nombre',
        'edad',
        'sexo',
        'correlativo_segmento'
    ];

    // Relación con el segmento
    public function segment()
    {
        return $this->belongsTo(Segment::class, 'correlativo_segmento', 'correlativo_segmento');
    }
}
