@extends('layouts.main')
@section('content')


<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
	    <div class="card">
             	<div class="card-header">
		<div class="row">
    		    <div class="col-12">
    			<div id="segmentos">
            		    <!-- Contenido de Hogares -->
    			    <div class="row">
            			<div class="col-lg-12 margin-tb">
            	 		<div class="pull-left">
            			    <h2>Segmentos</h2>
            			</div>
            			<div class="pull-right">
            			    <a class="btn btn-outline-dark" href="{{ route('segment_user.index') }}"><i class='bx bxs-user-plus'></i> Asignar segmento</a>
            			</div>
             		        </div>
			    </div>
    			</div>
		    </div>
		</div>
	        </div>
	    	<div class="card-body"> 
		<table id="segmentsTable" class="table table-hover responsive nowrap" style="width:100%">
     		    <thead>
            		<tr>
                	    <th>No</th>
                   	    <th>Correlativo Segmento</th>
                <th>Departamento</th>
                <th>Municipio</th>
                <th>Asignado</th>
		<th>Coordinacion local</th>
		<th>F. Hogar</th>
		<th>F. 0-4</th>
		<th>F. 5-7</th>
		<th>F. 8-11</th>
		<th>F. 12-17</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($segments as $index => $segment)
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td>{{ $segment->correlativo_segmento }}</td>
                    <td>{{ $segment->departamento->nombre  }}</td>
                    <td>{{ $segment->municipio->nombre  }}</td>
                    <td><i class='bx bx-circle'></i> <i class='bx bx-circle'></i> <i class='bx bx-circle'></i></td>
		    <td><i class='bx bx-circle'></i></td>
		    <td><i class='bx bx-circle'></i></td>
		    <td><i class='bx bx-circle'></i></td>
                    <td><i class='bx bx-circle'></i></td>
                    <td><i class='bx bx-circle'></i></td>
		    <td><i class='bx bx-circle'></i></td>
                    <td>
                        <div class="dropdown">
                            <button class="btn btn-sm btn-icon" type="button" id="dropdownMenuButton2" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="bx bx-dots-horizontal-rounded" data-toggle="tooltip" data-placement="top" title="Acciones"></i>
                            </button>
                            <div class="dropdown-menu" aria-labelledby="dropdownMenuButton2">
				<a class="dropdown-item text-secondary" href="#"><i class="bx bx-user-check mr-2"></i> Asignar segmento</a>
				<a class="dropdown-item text-secondary" href="#"><i class="bx bxs-time mr-2"></i> Línea de tiempo</a>
                                <a class="dropdown-item text-secondary" href="{{ route('coordinador.view', ['correlativo_segmento' => $segment->correlativo_segmento]) }}"><i class="bx bxs-show mr-2"></i> Ver información</a>
                                <a class="dropdown-item text-secondary" href="#"><i class="bx bxs-edit mr-2"></i> Editar información</a>
                            </div>
                        </div>
                    </td>
                </tr>
            @endforeach

        </tbody>
    </table>
</div>
</div>
</div>
</div>
</div>

@endsection

<!-- Script para inicializar el DataTable -->
@push('scripts')
<script>
$(document).ready(function() {
    $('#segmentsTable').DataTable({
        language: {
                url: '/js/i18n/es-MX.json'
        },
	pagingType: "simple_numbers",
        scrollX: true,
	dom: '<"top"f>rt<"bottom"lip><"clear">',
    	bootstrap: true,
	paging: true,	
        responsive: false, // Desactivar el responsive para evitar el botón de "+"
        autoWidth: false,
    });

    $(".dataTables_filter input")
        .attr("placeholder", "Buscar aqui...")
        .css({
            width: "300px",
            display: "inline-block"
        });

    // Inicializar tooltips manualmente
    $('[data-toggle="tooltip"]').tooltip();
});
</script>
@endpush
