@extends('layouts.main')

@section('content')
    <div class="container">
	<h1>Listado de Hogares</h1>
       	@foreach($households as $household)
            <div class="household">
        	<h2>Segmento: {{ $household->correlativo_segmento }}</h2>
		<h4>Número de vivienda: {{ $household->numero_vivienda }}</h4>
        	<table class="table">
                    <thead>
                        <tr>
                            <th>Nombre</th>
                            <th>Apellido</th>
                            <th>Edad</th>
                            <th>Fecha de Nacimiento</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($household->members as $member)
                            <tr>
                                <td>{{ $member->nombre }}</td>
                                <td>{{ $member->apellido }}</td>
                                <td>{{ $member->edad_anio }}</td>
                                <td>{{ $member->fecha_nacimiento }}</td>
                                <td>
                                    <a href="#" class="btn btn-sm btn-primary">
                                        <i class='bx bx-edit-alt'></i> Editar
                                    </a>
                                    <a href="#" class="btn btn-sm btn-danger">
                                        <i class='bx bx-trash'></i> Eliminar
                                    </a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @endforeach
    </div>
@endsection
