<!-- resources/views/form1.blade.php -->
@extends('layouts.main')

@section('content')
<div class="content-wrapper">
   <div class="content-header">
    <div class="container-fluid">
    <div class="row mb-2">
       <div class="col-sm-6">
	   <h1 class="header-form">Formulario 1. Coordinacion local.</h1>
       </div>
       <div class="col-sm-6">
   	     <ol class="breadcrumb float-sm-right">
		<li class="breadcrumb-item">Inicio</li>
		<li class="breadcrumb-item active">Formulario 1</li>
	     </ol>
       </div>
     </div>
     </div>
   </div>
   <div class="content">
   <div class="container-fluid">
    <div class="row">
	<div class="col-lg-6">
    <!-- Formulario -->
	<div class="card">
		<div class="card-header border-0">
		<div class="d-flex justify-content-between">
		<h3 class="card-title">Busqueda de datos</h3>
		</div>
		</div>
		<div class="card-body">
    <form action="{{ route('form1.buscar') }}" method="POST">
        @csrf
	<div class="row center">
             <div class="col-md-12" style="background-color: #343a40; color: white;">
                Parámetros de búsqueda específica
             </div>   
        </div>
	<div class="row" style="background-color: darkgray; color: white;">
                <div class="col-md-6">
			<label for="anno" class="form-label"><b>Año</b></label>
                </div>
                <div class="col-md-6">
                    <select class="form-control select2" name="anno" id="anno">
                        <option value="2024">2024</option>
                        <!-- Puedes agregar opciones para años aquí -->
                    </select>
                </div>
            </div>
	   <div class="row" style="background-color: gray; color: white;">
                <div class="col-md-6">
                    <label for="segmento" class="form-label"><b>Correlativo del Segmento Cartográfico</b></label>
                </div>
                <div class="col-md-6">
                    <select class="form-control" id="segmento" name="segmento">
                        <option value="" disabled selected>Seleccione el segmento</option>
                        <!-- ... (opciones de cantones) ... -->
                      </select>
                </div>
            </div>
            <div class="row" style="background-color: darkgray; color: white;">
                <div class="col-md-6">
                    <label for="region_salud" class="form-label"><b>Región de Salud</b></label>
                </div>
                <div class="col-md-6">
            		<select class="form-control" id="region" name="region">
                		<option value="">Seleccione una región</option>
                		<!-- Opciones se llenarán dinámicamente -->
            		</select>
        	</div>
	   </div>	
           <div class="row" style="background-color: gray; color: white;">
                <div class="col-md-6">
            		<label for="department" class="form-label">Departamento</label>
		</div>
                <div class="col-md-6">            
			<select class="form-control" id="depa" name="depa" disabled>
                		<option value="">Seleccione un departamento</option>
                		<!-- Opciones se llenarán dinámicamente -->
            		</select>
        	</div>
	   </div>
           <div class="row" style="background-color: darkgray; color: white;">
                <div class="col-md-6">
            		<label for="municipality" class="form-label">Municipio</label>
        	</div>
                <div class="col-md-6">
			<select class="form-control" id="muni" name="muni" disabled>
	                	<option value="">Seleccione un municipio</option>
        	        	<!-- Opciones se llenarán dinámicamente -->
            		</select>
        	</div>
           </div>
           <div class="row" style="background-color: gray; color: white;">
                <div class="col-md-6">
	            <label for="district" class="form-label">Distrito</label>
            	 </div>
                <div class="col-md-6">	
		   <select class="form-control" id="distrito" name="distrito" disabled>
                	<option value="">Seleccione un distrito</option>
                	<!-- Opciones se llenarán dinámicamente -->
            	   </select>
	        </div>
           </div>
           <div class="row" style="background-color: darkgray; color: white;">
                <div class="col-md-6">
            	   <label for="canton" class="form-label">Cantón</label>
            	   </div>
                <div class="col-md-6">
		   <select class="form-control" id="canton" name="canton" disabled>
                		<option value="">Seleccione un cantón</option>
                		<!-- Opciones se llenarán dinámicamente -->
            	   </select>
        	</div>
            </div>
           <div class="row" style="background-color: gray; color: white;">
                <div class="col-md-6">
            	   <label for="segment" class="form-label">Periodo de coordinación</label>
            	</div>
                <div class="col-md-6">
		   <div id="reportrange" style="background: #fff; cursor: pointer; padding: 5px 10px; border: 1px solid #ccc; width: 100%">
    			<i class="bx bx-calendar"></i>&nbsp;
    			<span></span> <i class="bx bx-chevron-down"></i>
		   </div>
	        </div>
	   </div>
           <div class="row">
                <div class="col-md-12 text-right btn-top-mgn"> <!-- Agrega la clase text-right para alinear a la derecha -->
                    <div class="d-grid gap-2 d-md-block">
                        <button type="button" class="btn btn-outline-orange btn-sm btn-all-w" id="buscarBtn">Buscar</button>
                    </div>
                </div>
            </div>
    </form>
   </div>
   </div>
   </div>
   <div class="col-lg-6">
    <!-- DataTable -->
    <div class="card">
	<div  class="card-header border-0">
	   <div class="d-flex justify-content-between">
		<h3 class="card-title">LISTADO DE FORMULARIOS</h3>
		<button type="button" class="btn btn-outline-orange btn-sm" id="addForm1" onclick="location.href='http://146.190.168.167/form1/add'">Nuevo registro</button>

	   </div>
	</div>
	<div class="card-body">
    <table id="example" class="table table-striped table-bordered dt-responsive nowrap" style="width:100%">
        <thead>
            <tr>
                <th>Name</th>
                <th>Position</th>
                <th>Office</th>
                <th>Age</th>
                <th>Start date</th>
                <th>Salary</th>
            </tr>
        </thead>
        <tbody>
            <!-- Example data -->
            <tr>
                <td>Tiger Nixon</td>
                <td>System Architect</td>
                <td>Edinburgh</td>
                <td>61</td>
                <td>2011/04/25</td>
                <td>$320,800</td>
            </tr>
        </tbody>
    </table>
	</div>
   </div>
</div>
</div>
</div>
@endsection

@push('scripts')
    @vite(['resources/js/populateSelect.js'])
   <script>
        $(document).ready(function() {
            $('#segmento').select2({
                placeholder: "Seleccione el segmento",
                allowClear: true
            })
        });
   </script>
<script type="text/javascript">
$(function() {

    var start = moment().subtract(29, 'days');
    var end = moment();

    function cb(start, end) {
        $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
    }

    $('#reportrange').daterangepicker({
        startDate: start,
        endDate: end,
        ranges: {
           'Today': [moment(), moment()],
           'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
           'Last 7 Days': [moment().subtract(6, 'days'), moment()],
           'Last 30 Days': [moment().subtract(29, 'days'), moment()],
           'This Month': [moment().startOf('month'), moment().endOf('month')],
           'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
        }
    }, cb);

    cb(start, end);

});
</script>
@endpush

