<!-- resources/views/household_members/edit.blade.php -->

@extends('layouts.main')

@section('content')
<div class="container">
    <h1>Editar Miembro del Hogar</h1>
    <form method="POST" action="{{ route('household_members.update', $householdMember->id) }}">
        @csrf
        @method('PUT')
        <div class="mb-3">
            <label for="household_id" class="form-label">Hogar</label>
            <select class="form-control" id="household_id" name="household_id" required>
                @foreach($households as $household)
                    <option value="{{ $household->id }}" {{ $householdMember->household_id == $household->id ? 'selected' : '' }}>
                        {{ $household->numero_vivienda }}
                    </option>
                @endforeach
            </select>
        </div>
        <div class="mb-3">
            <label for="numero_de_linea" class="form-label">Número de Línea</label>
            <input type="number" class="form-control" id="numero_de_linea" name="numero_de_linea" value="{{ $householdMember->numero_de_linea }}" required>
        </div>
        <div class="mb-3">
            <label for="nombre" class="form-label">Nombre</label>
            <input type="text" class="form-control" id="nombre" name="nombre" value="{{ $householdMember->nombre }}" required>
        </div>
        <div class="mb-3">
            <label for="apellido" class="form-label">Apellido</label>
            <input type="text" class="form-control" id="apellido" name="apellido" value="{{ $householdMember->apellido }}" required>
        </div>
        <div class="mb-3">
            <label for="fecha_nacimiento" class="form-label">Fecha de Nacimiento</label>
            <input type="date" class="form-control" id="fecha_nacimiento" name="fecha_nacimiento" value="{{ $householdMember->fecha_nacimiento->format('Y-m-d') }}" required>
        </div>
        <div class="mb-3">
            <label for="edad" class="form-label">Edad</label>
            <input type="date" class="form-control" id="edad" name="edad" value="{{ $householdMember->edad->format('Y-m-d') }}" required>
        </div>
        <button type="submit" class="btn btn-primary">Actualizar Miembro</button>
    </form>
</div>
@endsection
