<!-- resources/views/household_teams/index.blade.php -->

@extends('layouts.main')

@section('content')
<div class="container">
    <h1>Household Teams</h1>
    <a href="{{ route('household_teams.create') }}" class="btn btn-primary mb-3">Asignar Segmento</a>

    @if(session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    <table id="householdTeamsTable" class="display compact" style="width:100%" >
        <thead>
            <tr>
                <th>Correlativo Segmento</th>
                <th>Departamento</th>
                <th>Municipio</th>
                <th>Distrito</th>
                <th>Cantón</th>
                <th>Equipo</th>
                <th>Usuario</th>
                <th>Reasignaciones</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            @foreach($segmentTeam as $segmentTeam)
                <tr>
                    <td>{{ $segmentTeam->segment ? $segmentTeam->segment->correlativo_segmento : 'N/A' }}</td>
                    <td>{{ $segmentTeam->segment ? $segmentTeam->segment->dpto : 'N/A' }}</td>
                    <td>{{ $segmentTeam->segment ? $segmentTeam->segment->muni : 'N/A' }}</td>
                    <td>{{ $segmentTeam->segment ? $segmentTeam->segment->distrito : 'N/A' }}</td>
                    <td>{{ $segmentTeam->segment ? $segmentTeam->segment->canton : 'N/A' }}</td>
                    <td>{{ $segmentTeam->team ? $segmentTeam->team->name : 'N/A' }}</td>
                    <td>{{ $segmentTeam->user ? $segmentTeam->user->name : 'N/A' }}</td>
		    <td>{{ $segmentTeam->reassignment_count }}</td>
                    <td>
                         <a href="{{ route('household_teams.reassign', $segmentTeam->id) }}" class="btn btn-warning btn-sm"><i class='bx bx-repost'></i></a>
			 <a href="{{ route('household_teams.showReassignments', $segmentTeam->correlativo_segmento) }}" class="btn btn-info">
                            <i class='bx bx-info-circle'></i>
                        </a>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        $('#householdTeamsTable').DataTable({
            responsive: true,
            autoWidth: false,
            language: {
                url: '//cdn.datatables.net/plug-ins/1.11.5/i18n/Spanish.json'
            }
        });
    });
</script>
@endpush

