@extends('layouts.main')

@section('content')
<div class="container">
    <h2>Crear Condiciones</h2>

    <!-- Seleccionar pregunta -->
    <div class="form-group">
        <label for="question">Seleccionar Pregunta</label>
        <select id="question" class="form-control">
            <option value="">Selecciona una pregunta</option>
            @foreach($questions as $question)
                <option value="{{ $question->id }}">{{ $question->question_text }}</option>
            @endforeach
        </select>
    </div>

    <!-- Mostrar condiciones existentes -->
    <div id="existing-conditions">
        <h4>Condiciones existentes</h4>
        <ul id="conditions-list"></ul>
    </div>

    <!-- Campo para elegir el tipo de criterio -->
    <div class="form-group">
        <label for="criteria">Criterios</label>
        <select id="criteria" class="form-control">
            <option value="all">La pregunta debe cumplir todos estos criterios</option>
            <option value="any">La pregunta debe cumplir alguno de estos criterios</option>
        </select>
    </div>

    <!-- Formulario dinámico para agregar condiciones -->
    <div id="new-condition-form">
        <h4>Añadir Condición</h4>
        <div class="condition-form-template" style="display:none;">
            <div class="condition-form">
                <div class="form-group">
                    <label for="condition_type">Tipo de Condición</label>
                    <select class="form-control condition-type" name="condition_type">
                        <option value="option">Opción</option>
                        <option value="validation">Validación</option>
                    </select>
                </div>

                <!-- Si el tipo es opción -->
                <div class="form-group condition-option-fields" style="display:none;">
                    <label for="dependent_question">Pregunta Dependiente</label>
                    <select class="form-control dependent-question" name="dependent_question_id">
                        <option value="">Selecciona una pregunta</option>
                        @foreach($questions as $question)
                            <option value="{{ $question->id }}">{{ $question->question_text }}</option>
                        @endforeach
                    </select>
                    
                    <label for="option_type">Tipo de Opción</label>
                    <select class="form-control option-type" name="option_type">
                        <option value="equals">Equals</option>
                        <option value="not_equals">Not Equals</option>
                        <option value="was_answered">Was Answered</option>
                        <option value="not_answered">Not Answered</option>
                    </select>

                    <label for="option_value">Valor de Opción</label>
                    <input type="text" class="form-control option-value" name="option_value" placeholder="Valor">
                </div>

                <!-- Si el tipo es validación -->
                <div class="form-group condition-validation-fields" style="display:none;">
                    <label for="validation_type">Tipo de Validación</label>
                    <select class="form-control validation-type" name="validation_type">
                        <option value="equals">Equals</option>
                        <option value="greater_than">Greater Than</option>
                        <option value="less_than">Less Than</option>
                    </select>

                    <label for="validation_value">Valor de Validación</label>
                    <input type="text" class="form-control validation-value" name="validation_value" placeholder="Valor">
                </div>

                <button class="btn btn-danger remove-condition">Eliminar</button>
            </div>
        </div>
    </div>

    <button id="add-condition" class="btn btn-primary">Añadir Nueva Condición</button>
    <button id="save-conditions" class="btn btn-success">Guardar Condiciones</button>
</div>

<script>
    document.getElementById('add-condition').addEventListener('click', function() {
        const formTemplate = document.querySelector('.condition-form-template');
        const newForm = formTemplate.cloneNode(true);
        newForm.style.display = 'block'; // Mostrar el formulario
        newForm.classList.remove('condition-form-template'); // Quitar la clase de plantilla

        // Añadir funcionalidad de eliminación
        newForm.querySelector('.remove-condition').addEventListener('click', function() {
            newForm.remove();
        });

        // Cambio de visibilidad de campos según el tipo de condición
        newForm.querySelector('.condition-type').addEventListener('change', function() {
            const optionFields = newForm.querySelector('.condition-option-fields');
            const validationFields = newForm.querySelector('.condition-validation-fields');
            if (this.value === 'option') {
                optionFields.style.display = 'block';
                validationFields.style.display = 'none';
            } else {
                optionFields.style.display = 'none';
                validationFields.style.display = 'block';
            }
        });

        // Insertar el nuevo formulario en el contenedor
        document.getElementById('new-condition-form').appendChild(newForm);
    });

    // Guardar las condiciones usando AJAX
    document.getElementById('save-conditions').addEventListener('click', function() {
        const questionId = document.getElementById('question').value;
        const criteria = document.getElementById('criteria').value;
        const conditionForms = document.querySelectorAll('.condition-form');

        let conditions = [];

        conditionForms.forEach(function(form) {
            const conditionType = form.querySelector('.condition-type').value;
            let condition = { type: conditionType };

            if (conditionType === 'option') {
                condition.dependent_question_id = form.querySelector('.dependent-question').value;
                condition.option_type = form.querySelector('.option-type').value;
                condition.option_value = form.querySelector('.option-value').value;
            } else if (conditionType === 'validation') {
                condition.validation_type = form.querySelector('.validation-type').value;
                condition.validation_value = form.querySelector('.validation-value').value;
            }

            conditions.push(condition);
        });

        // Enviar las condiciones al servidor
        fetch('{{ route('conditions.store') }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            body: JSON.stringify({
                question_id: questionId,
                criteria: criteria,
                conditions: conditions
            })
        }).then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('Condiciones guardadas correctamente');
                // Aquí puedes actualizar la lista de condiciones existentes sin recargar la página
            }
        });
    });
</script>
@endsection
