@extends('layouts.app')

@section('content')
<div class="container">
    <h1>Crear Condiciones para la Pregunta</h1>

    <!-- Mostrar mensajes de éxito -->
    @if(session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    <!-- Formulario para seleccionar la pregunta principal -->
    <form id="condition-form">
        @csrf
        <div class="form-group">
            <label for="question">Seleccionar Pregunta</label>
            <select class="form-control" id="question" name="question_id">
                <option value="">Seleccione una pregunta</option>
                @foreach($questions as $question)
                    <option value="{{ $question->id }}">{{ $question->question_text }}</option>
                @endforeach
            </select>
        </div>

        <!-- Campo para seleccionar la lógica de condiciones -->
        <div class="form-group">
            <label for="criteria">Criterio de Condición</label>
            <select class="form-control" id="criteria" name="criteria">
                <option value="all">La pregunta debe cumplir todos estos criterios</option>
                <option value="any">La pregunta debe cumplir alguno de estos criterios</option>
            </select>
        </div>

        <!-- Contenedor para formularios de condiciones dinámicas -->
        <div id="new-condition-form">
            <!-- Los formularios de condiciones dinámicas se agregarán aquí -->
        </div>

        <!-- Botón para agregar nuevas condiciones -->
        <button type="button" class="btn btn-primary" id="add-condition">Añadir Nueva Condición</button>
        <br><br>

        <!-- Botón para guardar las condiciones -->
        <button type="button" class="btn btn-success" id="save-conditions">Guardar Condiciones</button>
    </form>

    <!-- Condiciones existentes -->
    <h2>Condiciones Existentes</h2>
    <ul id="existing-conditions">
        <!-- Aquí se mostrarán las condiciones existentes -->
        @foreach($existingConditions as $condition)
            <li>
                @if($condition->type == 'option')
                    Opción: Si "{{ $condition->dependentQuestion->question_text }}" es "{{ $condition->option_value }}" entonces...
                @elseif($condition->type == 'validation')
                    Validación: Si "{{ $condition->question->question_text }}" cumple con "{{ $condition->validation_type }}" "{{ $condition->validation_value }}"...
                @endif
            </li>
        @endforeach
    </ul>
</div>

<!-- Scripts -->
<script>
    // Código para agregar nuevas condiciones
    document.getElementById('add-condition').addEventListener('click', function() {
        const newForm = document.createElement('div');
        newForm.classList.add('condition-form');

        // Campo para seleccionar el tipo de condición
        const conditionTypeLabel = document.createElement('label');
        conditionTypeLabel.textContent = 'Tipo de Condición';
        const conditionTypeSelect = document.createElement('select');
        conditionTypeSelect.classList.add('form-control', 'condition-type');

        // Opciones para el tipo de condición
        const optionOption = document.createElement('option');
        optionOption.value = 'option';
        optionOption.textContent = 'Opción';

        const validationOption = document.createElement('option');
        validationOption.value = 'validation';
        validationOption.textContent = 'Validación';

        const defaultOption = document.createElement('option');
        defaultOption.value = '';
        defaultOption.textContent = 'Seleccione tipo de condición';

        conditionTypeSelect.appendChild(defaultOption);
        conditionTypeSelect.appendChild(optionOption);
        conditionTypeSelect.appendChild(validationOption);

        // Agregar el campo al nuevo formulario
        newForm.appendChild(conditionTypeLabel);
        newForm.appendChild(conditionTypeSelect);

        // Contenedor para los campos dependientes de la opción seleccionada
        const optionFields = document.createElement('div');
        optionFields.classList.add('condition-option-fields');
        optionFields.style.display = 'none';

        const validationFields = document.createElement('div');
        validationFields.classList.add('condition-validation-fields');
        validationFields.style.display = 'none';

        // Crear campos para las condiciones de tipo opción
        const dependentQuestionLabel = document.createElement('label');
        dependentQuestionLabel.textContent = 'Pregunta Dependiente';
        const dependentQuestionSelect = document.createElement('select');
        dependentQuestionSelect.classList.add('form-control', 'dependent-question');
        
        // Llenar con preguntas
        @foreach($questions as $question)
            const questionOption = document.createElement('option');
            questionOption.value = '{{ $question->id }}';
            questionOption.textContent = '{{ $question->question_text }}';
            dependentQuestionSelect.appendChild(questionOption);
        @endforeach

        const optionTypeLabel = document.createElement('label');
        optionTypeLabel.textContent = 'Tipo de Opción';
        const optionTypeSelect = document.createElement('select');
        optionTypeSelect.classList.add('form-control', 'option-type');

        const equalsOption = document.createElement('option');
        equalsOption.value = 'equals';
        equalsOption.textContent = 'Igual a';

        const notEqualsOption = document.createElement('option');
        notEqualsOption.value = 'not_equals';
        notEqualsOption.textContent = 'No igual a';

        optionTypeSelect.appendChild(equalsOption);
        optionTypeSelect.appendChild(notEqualsOption);

        const optionValueLabel = document.createElement('label');
        optionValueLabel.textContent = 'Valor de Opción';
        const optionValueInput = document.createElement('input');
        optionValueInput.classList.add('form-control', 'option-value');
        optionValueInput.type = 'text';

        // Añadir campos de opción al contenedor de opción
        optionFields.appendChild(dependentQuestionLabel);
        optionFields.appendChild(dependentQuestionSelect);
        optionFields.appendChild(optionTypeLabel);
        optionFields.appendChild(optionTypeSelect);
        optionFields.appendChild(optionValueLabel);
        optionFields.appendChild(optionValueInput);

        // Crear campos para las condiciones de tipo validación
        const validationTypeLabel = document.createElement('label');
        validationTypeLabel.textContent = 'Tipo de Validación';
        const validationTypeSelect = document.createElement('select');
        validationTypeSelect.classList.add('form-control', 'validation-type');

        const equalsValidationOption = document.createElement('option');
        equalsValidationOption.value = 'equals';
        equalsValidationOption.textContent = 'Igual a';

        const notEqualsValidationOption = document.createElement('option');
        notEqualsValidationOption.value = 'not_equals';
        notEqualsValidationOption.textContent = 'No igual a';

        validationTypeSelect.appendChild(equalsValidationOption);
        validationTypeSelect.appendChild(notEqualsValidationOption);

        const validationValueLabel = document.createElement('label');
        validationValueLabel.textContent = 'Valor de Validación';
        const validationValueInput = document.createElement('input');
        validationValueInput.classList.add('form-control', 'validation-value');
        validationValueInput.type = 'text';

        // Añadir campos de validación al contenedor de validación
        validationFields.appendChild(validationTypeLabel);
        validationFields.appendChild(validationTypeSelect);
        validationFields.appendChild(validationValueLabel);
        validationFields.appendChild(validationValueInput);

        // Añadir ambos contenedores (opción y validación) al formulario
        newForm.appendChild(optionFields);
        newForm.appendChild(validationFields);

        // Crear el botón para eliminar esta condición
        const removeConditionButton = document.createElement('button');
        removeConditionButton.type = 'button';
        removeConditionButton.classList.add('btn', 'btn-danger', 'remove-condition');
        removeConditionButton.textContent = 'Eliminar Condición';

        removeConditionButton.addEventListener('click', function() {
            newForm.remove();
        });

        newForm.appendChild(removeConditionButton);

        // Agregar el evento de cambio para alternar entre campos de opción y validación
        conditionTypeSelect.addEventListener('change', function() {
            if (this.value === 'option') {
                optionFields.style.display = 'block';
                validationFields.style.display = 'none';
            } else {
                optionFields.style.display = 'none';
                validationFields.style.display = 'block';
            }
        });

        // Añadir el nuevo formulario al contenedor
        document.getElementById('new-condition-form').appendChild(newForm);
    });

    // Guardar las condiciones usando AJAX
    document.getElementById('save-conditions').addEventListener('click', function() {
        const questionId = document.getElementById('question').value;
        const criteria = document.getElementById('criteria').value;
        const conditionForms = document.querySelectorAll('.condition-form');

        let conditions = [];

        conditionForms.forEach(function(form) {
            const conditionType = form.querySelector('.condition-type').value;
            let condition = { type: conditionType };

            if (conditionType === 'option') {
                condition.dependent_question_id = form.querySelector('.dependent-question').value;
                condition.option_type = form.querySelector('.option-type').value;
                condition.option_value = form.querySelector('.option-value').value;
            } else if (conditionType === 'validation') {
                condition.validation_type = form.querySelector('.validation-type').value;
                condition.validation_value = form.querySelector('.validation-value').value;
            }

            conditions.push(condition);
        });

        fetch('{{ route('conditions.store') }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            body: JSON.stringify({
                question_id: questionId,
                criteria: criteria,
                conditions: conditions
            })
        }).then(response => response.json())
          .then(data => {
              alert('Condiciones guardadas con éxito');
              window.location.reload();
          }).catch(error => console.error('Error:', error));
    });
</script>
@endsection
