@extends('layouts.main')

@section('content')
<div class="container">
    <h1>Editar Formulario</h1>

    <form action="{{ route('forms.update', $form->id) }}" method="POST">
        @csrf
        @method('PUT')
        <div class="mb-3">
            <label for="form_name" class="form-label">Nombre del Formulario</label>
            <input type="text" class="form-control @error('form_name') is-invalid @enderror" id="form_name" name="form_name" value="{{ old('form_name', $form->form_name) }}" required>
            @error('form_name')
            <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
        <div class="mb-3">
            <label for="description" class="form-label">Descripción</label>
            <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description">{{ old('description', $form->description) }}</textarea>
            @error('description')
            <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
        <button type="submit" class="btn btn-primary">Actualizar Formulario</button>
    </form>
</div>
@endsection
