@extends('layouts.main')

@section('content')
<div class="container">
    <h1>Formularios</h1>
    <a href="{{ route('forms.create') }}" class="btn btn-primary mb-3">Agregar Nuevo Formulario</a>

    @if (session('success'))
    <div class="alert alert-success">
        {{ session('success') }}
    </div>
    @endif

    <table class="table table-bordered">
        <thead>
            <tr>
                <th>ID</th>
                <th>Nombre del Formulario</th>
                <th>Descripción</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($forms as $form)
            <tr>
                <td>{{ $form->id }}</td>
                <td>{{ $form->form_name }}</td>
                <td>{{ $form->description }}</td>
                <td>
                    <a href="{{ route('forms.edit', $form->id) }}" class="btn btn-warning btn-sm">Editar</a>
                    <form action="{{ route('forms.destroy', $form->id) }}" method="POST" style="display:inline;">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger btn-sm">Eliminar</button>
                    </form>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection
