<div class="{{ $question->style_class }} mb-3"> <!-- El estilo de la clase se trae desde la base de datos -->
    @if($question->question_type != 'note')
        <!-- Etiqueta de la pregunta -->
        <label for="{{ $question->question_code }}" class="form-label">
	    <span class="question-number">@php
            // Buscamos el sectionQuestion que coincide tanto con el question_id como con el section_id
            $sectionQuestion = $sectionQuestions->where('section_id', $section->id)->firstWhere('question_id', $question->id);
        @endphp

        @if($sectionQuestion)
            {{ $sectionQuestion->question_enum }}  <!-- Numeración -->
        @endif.</span> <!-- Prefijo de numeración -->
            {{ $question->question_text }}
        </label>
    @endif

    <!-- Tipo de input según el tipo de pregunta -->
    @if($question->question_type == 'text')
        <input type="text" name="{{ $question->question_code }}" id="{{ $question->question_code }}" class="form-control" @if($question->is_required) required @endif>
    @elseif($question->question_type == 'date')
        <input type="date" name="{{ $question->question_code }}" id="{{ $question->question_code }}" class="form-control" @if($question->is_required) required @endif>
    @elseif($question->question_type == 'time')
        <input type="time" name="{{ $question->question_code }}" id="{{ $question->question_code }}" class="form-control" @if($question->is_required) required @endif>
    @elseif($question->question_type == 'numeric')
        <input type="number" name="{{ $question->question_code }}" id="{{ $question->question_code }}" class="form-control" @if($question->is_required) required @endif>
    @elseif($question->question_type == 'radio')
        @foreach($question->options as $option)
            <div class="form-check">
                <input class="form-check-input" type="radio" name="{{ $question->question_code }}" id="{{ $question->question_code }}_{{ $option->option_value }}" value="{{ $option->option_value }}">
                <label class="form-check-label" for="{{ $question->question_code }}_{{ $option->option_value }}">
                    {{ $option->option_text }}
                </label>
            </div>
        @endforeach
    @elseif($question->question_type == 'checkbox')
        @foreach($question->options as $option)
            <div class="form-check">
                <input class="form-check-input" type="checkbox" name="{{ $question->question_code }}[]" id="{{ $question->question_code }}_{{ $option->option_value }}" value="{{ $option->option_value }}">
                <label class="form-check-label" for="{{ $question->question_code }}_{{ $option->option_value }}">
                    {{ $option->option_text }}
                </label>
            </div>
        @endforeach
    @elseif($question->question_type == 'select')
        <select name="{{ $question->question_code }}" id="{{ $question->question_code }}" class="form-select" @if($question->is_required) required @endif>
            <option value="" disabled selected>Selecciona una opción</option>
            @if($question->question_code == 'correlativo_segmento')
                @foreach($segments as $segment)
                    <option value="{{ $segment->id }}">{{ $segment->correlativo_segmento }}</option>
                @endforeach
            @else
                @foreach($question->options as $option)
                    <option value="{{ $option->option_value }}">{{ $option->option_text }}</option>
                @endforeach
            @endif
        </select>
    @elseif($question->question_type == 'textarea')
        <textarea name="{{ $question->question_code }}" id="{{ $question->question_code }}" class="form-control" @if($question->is_required) required @endif></textarea>
    @elseif($question->question_type == 'note')
        <!-- Mostrar solo el texto de la nota como encabezado -->
        <h4 class="note-header">{{ $question->question_text }}</h4>
    @endif
</div>
