@extends('layouts.main') <!-- O el layout que estés usando -->

@section('content')
<div class="container">
    <h1>Editar Pregunta</h1>

    <!-- Mostrar errores de validación -->
    @if ($errors->any())
        <div class="alert alert-danger">
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif
	<div class="pull-right">
       <a class="btn btn-primary" href="{{ route('questions.index') }}"> Regresar </a>
	    </div>

    <!-- Formulario para editar la pregunta -->
    <form action="{{ route('questions.update', $question->id) }}" method="POST">
        @csrf
        @method('PUT')

        <div class="form-group">
            <label for="question_text">Texto de la Pregunta:</label>
            <input type="text" id="question_text" name="question_text" class="form-control" value="{{ old('question_text', $question->question_text) }}" required>
        </div>

        <div class="form-group">
            <label for="question_type">Tipo de Pregunta:</label>
            <select id="question_type" name="question_type" class="form-control" required>
                <option value="text" {{ $question->question_type === 'text' ? 'selected' : '' }}>Texto</option>
                <option value="radio" {{ $question->question_type === 'radio' ? 'selected' : '' }}>Radio</option>
                <option value="checkbox" {{ $question->question_type === 'checkbox' ? 'selected' : '' }}>Checkbox</option>
                <option value="select" {{ $question->question_type === 'select' ? 'selected' : '' }}>Select</option>
                <option value="textarea" {{ $question->question_type === 'textarea' ? 'selected' : '' }}>Textarea</option>
                <option value="matrix" {{ $question->question_type === 'matrix' ? 'selected' : '' }}>Matriz</option>
		<option value="date" {{ $question->question_type === 'date' ? 'selected' : '' }}>Fecha</option> 
		<option value="numeric"{{ $question->question_type === 'numeric' ? 'selected' : '' }}>Numérico</option> 
            </select>
        </div>

        <div class="form-group">
            <label for="is_required">¿Es Obligatorio?</label>
            <input type="checkbox" id="is_required" name="is_required" {{ old('is_required', $question->is_required) ? 'checked' : '' }}>
        </div>

        <div class="form-group">
            <label for="question_code">Código de la Pregunta:</label>
            <input type="text" id="question_code" name="question_code" class="form-control" value="{{ old('question_code', $question->question_code) }}">
        </div>

        <div class="form-group">
            <label for="style_class">Clase de Estilo:</label>
            <input type="text" id="style_class" name="style_class" class="form-control" value="{{ old('style_class', $question->style_class) }}">
        </div>

        <div class="form-group">
            <label for="condition_id">Condición Asociada:</label>
            <select id="condition_id" name="condition_id" class="form-control">
                <option value="">Ninguna</option>
                @foreach($conditions as $condition)
                    <option value="{{ $condition->id }}" {{ $question->condition_id == $condition->id ? 'selected' : '' }}>
                        {{ $condition->condition_text }}
                    </option>
                @endforeach
            </select>
        </div>

        <!-- Agregar campos específicos para preguntas de tipo matriz -->
        @if($question->question_type == 'matrix')
            <!-- Campos para filas y columnas de matriz, si es necesario -->
        @endif

        <button type="submit" class="btn btn-primary">Actualizar Pregunta</button>
    </form>
</div>
@endsection
