@extends('layouts.main')

@section('content')
<div class="container">
    <h1>Agregar Pregunta a Sección</h1>

    <form action="{{ route('section_questions.store') }}" method="POST">
        @csrf
        <div class="mb-3">
            <label for="section_id" class="form-label">Sección</label>
            <select id="section_id" name="section_id" class="form-select" required>
                <option value="">Seleccione una sección</option>
                @foreach ($sections as $section)
                    <option value="{{ $section->id }}">{{ $section->section_name }}</option>
                @endforeach
            </select>
        </div>
        <div class="mb-3">
            <label for="question_id" class="form-label">Pregunta</label>
            <select id="question_id" name="question_id" class="form-select" required>
                <option value="">Seleccione una pregunta</option>
                @foreach ($questions as $question)
                    <option value="{{ $question->id }}">{{ $question->question_text }}</option>
                @endforeach
        </select>
        </div>
        <div class="mb-3">
            <label for="question_order" class="form-label">Orden de la Pregunta</label>
            <input type="number" id="question_order" name="question_order" class="form-control" required>
        </div>
        <div class="mb-3">
            <label for="question_enum" class="form-label">Numeración de la Pregunta (opcional)</label>
            <input type="text" class="form-control" id="question_enum" name="question_enum">
        </div>
        <button type="submit" class="btn btn-primary">Guardar</button>
    </form>
</div>
@endsection
