@extends('layouts.main')

@section('content')
<div class="container">
    <h1>Editar Pregunta en Sección</h1>

    <!-- Formulario para editar la pregunta en la sección -->
    <form action="{{ route('section_questions.update', $sectionQuestion->id) }}" method="POST">
        @csrf
        @method('PUT')

        <div class="form-group">
            <label for="section_id">Sección</label>
            <select name="section_id" id="section_id" class="form-control">
                @foreach($sections as $section)
                    <option value="{{ $section->id }}" {{ $sectionQuestion->section_id == $section->id ? 'selected' : '' }}>
                        {{ $section->section_name }}
                    </option>
                @endforeach
            </select>
        </div>

        <div class="form-group">
            <label for="question_id">Pregunta</label>
            <select name="question_id" id="question_id" class="form-control">
                @foreach($questions as $question)
                    <option value="{{ $question->id }}" {{ $sectionQuestion->question_id == $question->id ? 'selected' : '' }}>
                        {{ $question->question_text }}
                    </option>
                @endforeach
            </select>
        </div>

        <div class="form-group">
            <label for="question_order">Orden</label>
            <input type="number" name="question_order" id="question_order" class="form-control" value="{{ $sectionQuestion->question_order }}">
        </div>

        <button type="submit" class="btn btn-success">Guardar Cambios</button>
        <a href="{{ route('section_questions.index') }}" class="btn btn-secondary">Cancelar</a>
    </form>
</div>
@endsection
