<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AppController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\SegmentController;
use App\Http\Controllers\HouseholdController;
use App\Http\Controllers\ApiController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Aquí puedes registrar rutas API para tu aplicación. Estas rutas son
| cargadas por el RouteServiceProvider y todas ellas se asignarán al
| grupo de middleware "api". ¡Haz algo genial!
|
*/

// Rutas para autenticación pública
Route::post('/login', [AuthController::class, 'login']);

// Ruta para verificar autenticación
Route::middleware('auth:sanctum')->get('/auth/check', [AuthController::class, 'check']);

// Rutas protegidas por autenticación
Route::middleware('auth:sanctum')->group(function () {
    Route::get('/apps', [AppController::class, 'index']);
    Route::post('/apps', [AppController::class, 'store']);
    Route::get('/apps/{id}', [AppController::class, 'show']);
    Route::put('/apps/{id}', [AppController::class, 'update']);
    Route::delete('/apps/{id}', [AppController::class, 'destroy']);

    // Rutas para roles
    Route::get('/roles', [RoleController::class, 'getRoles']);
    Route::get('/roles/{id}', [RoleController::class, 'show']);
    Route::get('/segments/active-count', [SegmentController::class, 'getActiveSegmentsCount']);
    Route::get('/segments', [ApiController::class, 'getSegments']);
    Route::get('/households/search', [HouseholdController::class, 'search']); // Buscar segmentos
    Route::get('/teams', [ApiController::class, 'getTeams']);
    Route::get('/segments/assigned-count', [SegmentController::class, 'getAssignedSegmentsCount']);
    Route::get('/households/count', [HouseholdController::class, 'getHouseholdsCount']);
    // Ruta para obtener el usuario autenticado
    Route::get('/user', function (Request $request) {
        return $request->user();
    });
    // Rutas para preguntas
    Route::get('/questions', [QuestionController::class, 'index']);
    Route::get('/questions/{id}', [QuestionController::class, 'show']);
    Route::post('/questions', [QuestionController::class, 'store']);
    Route::put('/questions/{id}', [QuestionController::class, 'update']);
    Route::delete('/questions/{id}', [QuestionController::class, 'destroy']);

    // Rutas para respuestas
    Route::get('/answers/{questionId}', [AnswerController::class, 'index']);
    Route::post('/answers', [AnswerController::class, 'store']);

    // Rutas para condiciones
    Route::get('/conditions', [ConditionController::class, 'index']);
    Route::post('/conditions', [ConditionController::class, 'store']);
    Route::put('/conditions/{id}', [ConditionController::class, 'update']);
    Route::delete('/conditions/{id}', [ConditionController::class, 'destroy']);

});
