<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                <div class="row">
                    <div class="col-12">
                        <div id="segmentos">
                            <!-- Contenido de Hogares -->
                            <div class="row">
                                <div class="col-lg-12 margin-tb">
                                <div class="pull-left">
                                    <h1>Listado de miembros</h1>
                                </div>
                                <div class="pull-right">
                                    <!-- Formulario de importación de Households -->
                                    <form action="<?php echo e(route('household_members.import')); ?>" method="POST" enctype="multipart/form-data">
                                        <?php echo csrf_field(); ?>
                                        <div class="form-group">
                                            <label for="file">Importar miembros</label>
                                            <input type="file" name="file" class="form-control">
                                        </div>
                                        <button type="submit" class="btn btn-success mt-2">Importar</button>
                                    </form>
                                </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                </div>
                <div class="card-body">
                    <table id="householdMembersTable" class="table table-hover responsive nowrap" style="width:100%">
                        <thead>
                           <tr>
				<th>No</th>
                                <th>Dirección</th>
                                <th>Orden Viv.</th>
                                <th>No Viv.</th>
				<th>No Linea</th>
                                <th>Nombre</th>
                                <th>Edad</th>
                                <th>Sexo</th>
                                <th>Grupo de Edad</th>
                                <th>Seleccionado</th>
                                <th>Acciones</th>
                           </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $members; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($index + 1); ?></td>
                                <td><?php echo e($member->household->direccion ?? '-'); ?></td>
                                <td><?php echo e($member->household->orden_vivienda ?? '-'); ?></td>
                                <td><?php echo e($member->household->numero_vivienda ?? '-'); ?></td>
                                <td><?php echo e($member->numero_de_linea); ?></td>
				<td><?php echo e($member->nombre); ?></td>
                                <td><?php echo e($member->edad); ?></td>
                                <td><?php echo e($member->sexo_texto); ?></td>
                                <td><?php echo e($member->grupo_edad_texto); ?></td>
                                <td><?php echo e($member->seleccionado_texto); ?></td>
                                <td>
                                    <a href="<?php echo e(route('household_members.edit', $member->id)); ?>" class="btn btn-warning"><i class='bx bx-edit'></i></a>
                                    <form action="<?php echo e(route('household_members.destroy', $member->id)); ?>" method="POST" style="display:inline;">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-danger"><i class='bx bx-trash'></i></button>
                                    </form>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {

    $('#householdMembersTable').DataTable({
        language: {
                url: '/js/i18n/es-MX.json'
        },
        pagingType: "simple_numbers",
        scrollX: true,
        dom: '<"top"f>rt<"bottom"lip><"clear">',
        bootstrap: true,
        paging: true,
        responsive: false, // Desactivar el responsive para evitar el botón de "+"
        autoWidth: false,
    });
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EncuestaProject/resources/views/household_members/index.blade.php ENDPATH**/ ?>