<!-- resources/views/teams/index.blade.php -->


<?php $__env->startSection('content'); ?>
<div class="container">
    <h1>Teams</h1>
    <a href="<?php echo e(route('teams.create')); ?>" class="btn btn-primary">Create Team</a>
    <table class="table table-bordered mt-3">
        <thead>
            <tr>
                <th>Name</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $teams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $team): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($team->name); ?></td>
                <td>
                    <a href="<?php echo e(route('teams.edit', $team->id)); ?>" class="btn btn-warning">Edit</a>
                    <form action="<?php echo e(route('teams.destroy', $team->id)); ?>" method="POST" style="display:inline;">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" class="btn btn-danger">Delete</button>
                    </form>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/EncuestaProject/resources/views/teams/index.blade.php ENDPATH**/ ?>